/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import javacard.security.CryptoException;
import javacard.security.RandomData;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.prng.DigestRandomGenerator;
import org.bouncycastle.crypto.prng.RandomGenerator;

public class RandomDataImpl
extends RandomData {
    byte algorithm;
    RandomGenerator engine;
    static SecureRandom random;

    public RandomDataImpl(byte algorithm) {
        this.algorithm = algorithm;
        this.engine = new DigestRandomGenerator((Digest)new SHA1Digest());
        this.engine.addSeedMaterial(random.generateSeed(8));
    }

    @Override
    public void generateData(byte[] buffer, short offset, short length) throws CryptoException {
        this.engine.nextBytes(buffer, (int)offset, (int)length);
    }

    @Override
    public void setSeed(byte[] buffer, short offset, short length) {
        this.engine.addSeedMaterial(Arrays.copyOfRange(buffer, (int)offset, (int)length));
    }

    @Override
    public byte getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public short nextBytes(byte[] buffer, short offset, short length) throws CryptoException {
        this.engine.nextBytes(buffer, (int)offset, (int)length);
        return (short)(offset + length);
    }

    static {
        try {
            random = SecureRandom.getInstanceStrong();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("No random?");
        }
    }
}

