/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;

public class JavaCardApiProcessor {
    public static void main(String[] args) throws Exception {
        File buildDir = new File(args[0]);
        if (!buildDir.exists() || !buildDir.isDirectory()) {
            throw new RuntimeException("Invalid directory: " + String.valueOf(buildDir));
        }
        System.out.println("Processing " + String.valueOf(buildDir));
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.javacard.framework.AIDProxy", "javacard.framework.AID", false);
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.javacard.framework.APDUProxy", "javacard.framework.APDU", false);
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.javacard.framework.AppletProxy", "javacard.framework.Applet", false);
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.javacard.framework.JCSystemProxy", "javacard.framework.JCSystem", false);
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.javacard.framework.UtilProxy", "javacard.framework.Util", false);
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.javacard.framework.OwnerPINProxy", "javacard.framework.OwnerPIN", false);
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.javacard.security.ChecksumProxy", "javacard.security.Checksum", true);
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.javacard.security.KeyAgreementProxy", "javacard.security.KeyAgreement", true);
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.javacard.security.KeyPairProxy", "javacard.security.KeyPair", false);
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.javacard.security.KeyBuilderProxy", "javacard.security.KeyBuilder", true);
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.javacard.security.MessageDigestProxy", "javacard.security.MessageDigest", true);
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.javacard.security.RandomDataProxy", "javacard.security.RandomData", true);
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.javacard.security.SignatureProxy", "javacard.security.Signature", true);
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.javacard.framework.CardExceptionProxy", "javacard.framework.CardException", false);
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.javacard.framework.CardRuntimeExceptionProxy", "javacard.framework.CardRuntimeException", false);
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.javacardx.security.SensitiveResultProxy", "javacardx.security.SensitiveResult", false);
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.javacardx.crypto.CipherProxy", "javacardx.crypto.Cipher", true);
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacard.framework.APDUException");
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacard.framework.ISOException");
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacard.framework.PINException");
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacard.framework.SystemException");
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacard.framework.TransactionException");
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacard.framework.UserException");
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacard.framework.service.ServiceException");
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacard.security.CryptoException");
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacardx.external.ExternalException");
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacardx.framework.tlv.TLVException");
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacardx.biometry1toN.Bio1toNException");
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacardx.framework.util.UtilException");
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacardx.biometry.BioException");
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacardx.framework.string.StringException");
        JavaCardApiProcessor.proxyClass(buildDir, "pro.javacard.engine.proxy.org.globalplatform.GPSystemProxy", "org.globalplatform.GPSystem", false);
    }

    public static void proxyClass(File buildDir, Class<?> proxyClass, Class<?> targetClass, boolean skipConstructor) throws IOException {
        JavaCardApiProcessor.proxyClass(buildDir, proxyClass.getName(), targetClass.getName(), skipConstructor, null);
    }

    public static void proxyClass(File buildDir, String proxyClassName, String targetClassName, boolean skipConstructor) throws IOException {
        JavaCardApiProcessor.proxyClass(buildDir, proxyClassName, targetClassName, skipConstructor, null);
    }

    public static void proxyClass(File buildDir, String proxyClassName, String targetClassName, boolean skipConstructor, Map<String, String> map) throws IOException {
        System.out.println("Proxying " + proxyClassName + " to " + targetClassName);
        File proxyFile = new File(buildDir, proxyClassName.replace(".", File.separator) + ".class");
        FileInputStream fProxyClass = new FileInputStream(proxyFile);
        FileInputStream fTargetClass = new FileInputStream(new File(buildDir, targetClassName.replace(".", File.separator) + ".class"));
        ClassReader crProxy = new ClassReader((InputStream)fProxyClass);
        ClassNode cnProxy = new ClassNode();
        crProxy.accept((ClassVisitor)cnProxy, 0);
        ClassReader crTarget = new ClassReader((InputStream)fTargetClass);
        ClassNode cnTarget = new ClassNode();
        crTarget.accept((ClassVisitor)cnTarget, 0);
        ClassNode cnProxyRemapped = new ClassNode();
        HashMap<String, String> mapping = map == null ? new HashMap<String, String>() : new HashMap<String, String>(map);
        mapping.put(cnProxy.name, cnTarget.name);
        if (map == null) {
            String innerClassName;
            if (cnProxy.innerClasses != null) {
                for (InnerClassNode innerClass : cnProxy.innerClasses) {
                    if (!innerClass.name.startsWith(cnProxy.name + "$")) continue;
                    innerClassName = innerClass.name.substring(cnProxy.name.length());
                    mapping.put(cnProxy.name + innerClassName, cnTarget.name + innerClassName);
                    System.out.println("Mapping " + cnProxy.name + innerClassName + " to " + cnTarget.name + innerClassName);
                }
            }
            if (cnProxy.innerClasses != null) {
                for (InnerClassNode innerClass : cnProxy.innerClasses) {
                    if (!innerClass.name.startsWith(cnProxy.name + "$")) continue;
                    innerClassName = innerClass.name.substring(cnProxy.name.length());
                    JavaCardApiProcessor.proxyClass(buildDir, cnProxy.name + innerClassName, cnTarget.name + innerClassName, false, mapping);
                }
            }
        }
        ClassRemapper ra = new ClassRemapper((ClassVisitor)cnProxyRemapped, (Remapper)new SimpleRemapper(mapping));
        cnProxy.accept((ClassVisitor)ra);
        ClassWriter cw = new ClassWriter(crTarget, 2);
        MergeAdapter ma = new MergeAdapter((ClassVisitor)cw, cnProxyRemapped, skipConstructor);
        cnTarget.accept((ClassVisitor)ma);
        fProxyClass.close();
        fTargetClass.close();
        FileOutputStream fos = new FileOutputStream(new File(buildDir, targetClassName.replace(".", File.separator) + ".class"));
        fos.write(cw.toByteArray());
        fos.close();
        if (!proxyFile.delete()) {
            System.err.println("Could not delete " + proxyFile.getAbsolutePath());
        }
    }

    public static void proxyExceptionClass(File buildDir, String targetClassName) throws IOException {
        FileInputStream fTargetClass = new FileInputStream(new File(buildDir, targetClassName.replace(".", File.separator) + ".class"));
        ClassReader crTarget = new ClassReader((InputStream)fTargetClass);
        ClassNode cnTarget = new ClassNode();
        crTarget.accept((ClassVisitor)cnTarget, 0);
        ClassWriter cw = new ClassWriter(2);
        ExceptionClassProxy ecc = new ExceptionClassProxy(cw, cnTarget.version, cnTarget.name, cnTarget.superName);
        cnTarget.accept((ClassVisitor)ecc);
        fTargetClass.close();
        FileOutputStream fos = new FileOutputStream(new File(buildDir, targetClassName.replace(".", File.separator) + ".class"));
        fos.write(cw.toByteArray());
        fos.close();
    }

    static class MergeAdapter
    extends ClassAdapter {
        private ClassNode cn;
        private String cname;
        private HashMap<String, MethodNode> cnMethods = new HashMap();
        private HashMap<String, FieldNode> cnFields = new HashMap();
        private boolean skipConstructor;

        public MergeAdapter(ClassVisitor cv, ClassNode cn, boolean skipConstructor) {
            super(cv);
            this.cn = cn;
            this.skipConstructor = skipConstructor;
            for (MethodNode mn : cn.methods) {
                if (skipConstructor && mn.name.equals("<init>")) continue;
                this.cnMethods.put(mn.name + mn.desc, mn);
            }
            for (FieldNode fn : cn.fields) {
                this.cnFields.put(fn.name + fn.desc, fn);
            }
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.cname = name;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.cnMethods.containsKey(name + desc) || (access & 5) == 0) {
                return null;
            }
            System.err.println("Uses original method: " + this.cname + "::" + name + desc);
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if ((access & 1) != 1) {
                System.out.println("skip field: " + this.cname + name + desc);
                return null;
            }
            return super.visitField(access, name, desc, signature, value);
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            for (FieldNode fn : this.cn.fields) {
                this.cv.visitField(fn.access, fn.name, fn.desc, fn.signature, fn.value);
            }
            for (MethodNode mn : this.cn.methods) {
                if (this.skipConstructor && mn.name.equals("<init>")) continue;
                String[] exceptions = new String[mn.exceptions.size()];
                mn.exceptions.toArray(exceptions);
                MethodVisitor mv = this.cv.visitMethod(mn.access, mn.name, mn.desc, mn.signature, exceptions);
                mn.instructions.resetLabels();
                mn.accept(mv);
            }
        }
    }

    static class ExceptionClassProxy
    extends ClassVisitor
    implements Opcodes {
        String superClassName;
        String className;

        public ExceptionClassProxy(ClassWriter cv, int classVersion, String exceptionClassName, String superClassName) {
            super(589824, (ClassVisitor)cv);
            this.superClassName = superClassName;
            this.className = exceptionClassName;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return null;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if ((access & 1) != 1) {
                System.out.println("Ignoring exception field " + name);
                return null;
            }
            return super.visitField(access, name, desc, signature, value);
        }

        public void visitEnd() {
            MethodVisitor mv = this.cv.visitMethod(1, "<init>", "(S)V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(21, 1);
            mv.visitMethodInsn(183, this.superClassName, "<init>", "(S)V", false);
            mv.visitInsn(177);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
            mv = this.cv.visitMethod(9, "throwIt", "(S)V", null, null);
            mv.visitCode();
            mv.visitTypeInsn(187, this.className);
            mv.visitInsn(89);
            mv.visitVarInsn(21, 0);
            mv.visitMethodInsn(183, this.className, "<init>", "(S)V", false);
            mv.visitInsn(191);
            mv.visitMaxs(3, 1);
            mv.visitEnd();
        }
    }

    static class ClassAdapter
    extends ClassNode
    implements Opcodes {
        public ClassAdapter(ClassVisitor cv) {
            super(589824);
            this.cv = cv;
        }

        public void visitEnd() {
            this.accept(this.cv);
        }
    }
}

