/*
 * Decompiled with CFR 0.152.
 */
package javacard.security;

import com.licel.jcardsim.crypto.MessageDigestImpl;
import javacard.security.CryptoException;
import javacard.security.InitializedMessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageDigest {
    public static final byte ALG_NULL = 0;
    public static final byte ALG_SHA = 1;
    public static final byte ALG_MD5 = 2;
    public static final byte ALG_RIPEMD160 = 3;
    public static final byte ALG_SHA_256 = 4;
    public static final byte ALG_SHA_384 = 5;
    public static final byte ALG_SHA_512 = 6;
    public static final byte ALG_SHA_224 = 7;
    public static final byte ALG_SHA3_224 = 8;
    public static final byte ALG_SHA3_256 = 9;
    public static final byte ALG_SHA3_384 = 10;
    public static final byte ALG_SHA3_512 = 11;
    public static final byte LENGTH_MD5 = 16;
    public static final byte LENGTH_RIPEMD160 = 20;
    public static final byte LENGTH_SHA = 20;
    public static final byte LENGTH_SHA_224 = 28;
    public static final byte LENGTH_SHA_256 = 32;
    public static final byte LENGTH_SHA_384 = 48;
    public static final byte LENGTH_SHA_512 = 64;
    public static final byte LENGTH_SHA3_224 = 28;
    public static final byte LENGTH_SHA3_256 = 32;
    public static final byte LENGTH_SHA3_384 = 48;
    public static final byte LENGTH_SHA3_512 = 64;

    protected MessageDigest() {
    }

    public abstract byte getAlgorithm();

    public abstract byte getLength();

    public abstract short doFinal(byte[] var1, short var2, short var3, byte[] var4, short var5) throws CryptoException;

    public abstract void update(byte[] var1, short var2, short var3) throws CryptoException;

    public abstract void reset();

    public static final MessageDigest getInstance(byte algorithm, boolean externalAccess) throws CryptoException {
        if (externalAccess) {
            CryptoException.throwIt((short)3);
        }
        MessageDigestImpl instance = new MessageDigestImpl(algorithm);
        return instance;
    }

    public static final InitializedMessageDigest getInitializedMessageDigestInstance(byte algorithm, boolean externalAccess) throws CryptoException {
        if (externalAccess) {
            CryptoException.throwIt((short)3);
        }
        MessageDigestImpl instance = new MessageDigestImpl(algorithm);
        return instance;
    }

    public static final class OneShot
    extends MessageDigest {
        private static final Logger log = LoggerFactory.getLogger(OneShot.class);
        private MessageDigest md;

        private OneShot() {
            log.debug("MessageDigest.OneShot");
        }

        public static OneShot open(byte algorithm) {
            OneShot one = new OneShot();
            one.md = MessageDigest.getInstance(algorithm, false);
            return one;
        }

        @Override
        public byte getAlgorithm() {
            return this.md.getAlgorithm();
        }

        @Override
        public byte getLength() {
            return this.md.getLength();
        }

        @Override
        public short doFinal(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException {
            return this.md.doFinal(inBuff, inOffset, inLength, outBuff, outOffset);
        }

        @Override
        public void update(byte[] bytes, short i, short i1) throws CryptoException {
            CryptoException.throwIt((short)5);
        }

        @Override
        public void reset() {
            this.md.reset();
        }

        public void close() {
            this.md = null;
        }
    }
}

