/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.engine.globalplatform;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Objects;
import javacard.framework.APDU;
import javacard.framework.ISOException;
import javacard.framework.Util;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.util.encoders.Hex;
import org.globalplatform.SecureChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.gp.GPCardKeys;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPSecureChannelVersion;
import pro.javacard.gp.GPUtils;
import pro.javacard.gp.keys.PlaintextKeys;

public class SCP02SecureChannelImpl
implements SecureChannel {
    private static final Logger log = LoggerFactory.getLogger(SCP02SecureChannelImpl.class);
    private final byte[] KVN = new byte[]{-1};
    private final byte[] SCP = new byte[]{2};
    private static final byte[] kdd = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private final byte[] ssc = new byte[2];
    private final byte[] card_challenge = new byte[8];
    private final byte[] host_challenge = new byte[8];
    private final byte[] icv = new byte[8];
    boolean open = false;
    private byte state = 0;
    private byte[] macKey;
    private byte[] encKey;
    private byte[] dekKey;

    @Override
    public short processSecurity(APDU apdu) throws ISOException {
        byte[] buffer;
        if (apdu.getCurrentState() == 0) {
            apdu.setIncomingAndReceive();
        }
        if ((buffer = apdu.getBuffer())[1] == 80) {
            if (buffer[0] != -128) {
                ISOException.throwIt((short)28160);
            }
            if (buffer[2] != 0 && buffer[3] != 0) {
                ISOException.throwIt((short)27270);
            }
            if (buffer[4] != 8) {
                ISOException.throwIt((short)26368);
            }
            this.resetSecurity();
            PlaintextKeys keys = PlaintextKeys.defaultKey();
            keys.diversify(GPSecureChannelVersion.SCP.SCP02, kdd);
            byte[] host_challenge = Arrays.copyOfRange(apdu.getBuffer(), 5, 13);
            byte[] card_challenge = GPUtils.concatenate((byte[][])new byte[][]{this.ssc, GPCrypto.random((int)6)});
            System.arraycopy(host_challenge, 0, this.host_challenge, 0, host_challenge.length);
            System.arraycopy(card_challenge, 0, this.card_challenge, 0, card_challenge.length);
            this.macKey = keys.getSessionKey(GPCardKeys.KeyPurpose.MAC, this.ssc);
            this.encKey = keys.getSessionKey(GPCardKeys.KeyPurpose.ENC, this.ssc);
            this.dekKey = keys.getSessionKey(GPCardKeys.KeyPurpose.DEK, this.ssc);
            byte[] cryptogram = GPCrypto.mac_3des((byte[])GPUtils.concatenate((byte[][])new byte[][]{host_challenge, card_challenge}), (byte[])this.encKey, (byte[])new byte[8]);
            byte[] resp = GPUtils.concatenate((byte[][])new byte[][]{kdd, this.KVN, this.SCP, card_challenge, cryptogram});
            System.arraycopy(resp, 0, buffer, 5, resp.length);
            return (short)resp.length;
        }
        if (buffer[1] == -126) {
            if (buffer[0] != -124) {
                ISOException.throwIt((short)28160);
            }
            if ((buffer[2] & 0xFFFFFFC0) != 0) {
                ISOException.throwIt((short)27270);
            }
            if ((buffer[2] & 0xFFFFFFCC) != 0) {
                ISOException.throwIt((short)27270);
            }
            if (buffer[3] != 0) {
                ISOException.throwIt((short)27270);
            }
            if (buffer[4] != 16) {
                ISOException.throwIt((short)26368);
            }
            this.process_mac(buffer, 0, apdu.getIncomingLength() + 5);
            byte[] host_cryptogram = GPCrypto.mac_3des((byte[])GPUtils.concatenate((byte[][])new byte[][]{this.card_challenge, this.host_challenge}), (byte[])this.encKey, (byte[])new byte[8]);
            if (!Arrays.equals(host_cryptogram, Arrays.copyOfRange(apdu.getBuffer(), 5, 5 + host_cryptogram.length))) {
                log.error("Host cryptogram check failed");
                ISOException.throwIt((short)25344);
            }
            this.state = (byte)(0xFFFFFF80 | buffer[2]);
            GPCrypto.buffer_increment((byte[])this.ssc);
            this.open = true;
            log.debug("Secure channel #{} state is now {}", (Object)Hex.toHexString((byte[])this.ssc), (Object)String.format("%02x", this.state));
            return 0;
        }
        ISOException.throwIt((short)27904);
        return 0;
    }

    void process_mac(byte[] buffer, int offset, int length) {
        try {
            int maclen = 8;
            byte[] mac = Arrays.copyOfRange(buffer, offset + length - 8, offset + length);
            log.trace("mac: {} (session open: {})", (Object)Hex.toHexString((byte[])mac), (Object)this.open);
            byte[] payload = Arrays.copyOfRange(buffer, offset + 5, offset + length - 8);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            bo.write(buffer[offset + 0] | 4);
            bo.write(buffer[offset + 1]);
            bo.write(buffer[offset + 2]);
            bo.write(buffer[offset + 3]);
            if (this.open && (this.state & 2) == 2) {
                log.trace("MAC payload encrypted");
                byte[] decrypted = SCP02SecureChannelImpl.des3_cbc_decrypt(payload, this.encKey, new byte[8]);
                log.trace("Decrypted: {}", (Object)Hex.toHexString((byte[])decrypted));
                byte[] unpadded = GPCrypto.unpad80((byte[])decrypted);
                bo.write(unpadded.length + 8);
                bo.write(unpadded);
            } else {
                log.trace("MAC payload not encrypted");
                bo.write(buffer[offset + 4]);
                bo.write(payload);
            }
            byte[] mac_input = bo.toByteArray();
            log.trace("mac input: {} icv: {}", (Object)Hex.toHexString((byte[])mac_input), (Object)Hex.toHexString((byte[])this.icv));
            byte[] check = GPCrypto.mac_des_3des((byte[])this.macKey, (byte[])mac_input, (byte[])this.icv);
            System.arraycopy(check, 0, this.icv, 0, this.icv.length);
            if (!Arrays.equals(check, mac)) {
                log.error("MAC mismatch: calculated {}, presented {}", (Object)Hex.toHexString((byte[])check), (Object)Hex.toHexString((byte[])mac));
                this.resetSecurity();
                ISOException.throwIt((short)27013);
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException((Throwable)e);
        }
    }

    @Override
    public short wrap(byte[] bytes, short i, short i1) throws ISOException {
        throw new UnsupportedOperationException("SecureChannel.wrap()");
    }

    private static byte[] des3_cbc_decrypt(byte[] data, byte[] key, byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
        cipher.init(2, GPCrypto.des3key((byte[])key), new IvParameterSpec(iv));
        return cipher.doFinal(data);
    }

    private static byte[] des3_ecb_decrypt(byte[] data, byte[] key) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
        cipher.init(2, GPCrypto.des3key((byte[])key));
        return cipher.doFinal(data);
    }

    @Override
    public short unwrap(byte[] bytes, short offset, short length) throws ISOException {
        log.trace("Unwrapping ...");
        int maclen = 8;
        byte[] cryptogram = Arrays.copyOfRange(bytes, offset + 5, offset + length - 8);
        try {
            log.trace("ICV encryption");
            byte[] newicv = GPCrypto.des_ecb((byte[])this.icv, (byte[])this.macKey);
            System.arraycopy(newicv, 0, this.icv, 0, newicv.length);
            if ((this.state & 1) == 1) {
                this.process_mac(bytes, offset, length);
            }
            log.trace("Cryptogram len={} {}", (Object)cryptogram.length, (Object)Hex.toHexString((byte[])cryptogram));
            if ((bytes[offset + 0] & 4) == 4 && (this.state & 2) == 2) {
                byte[] payload = SCP02SecureChannelImpl.des3_cbc_decrypt(cryptogram, this.encKey, new byte[8]);
                payload = GPCrypto.unpad80((byte[])payload);
                log.trace("Unwrapped: {}", (Object)Hex.toHexString((byte[])payload));
                Util.arrayCopyNonAtomic(payload, (short)0, bytes, (short)(offset + 5), (short)payload.length);
                bytes[offset + 4] = (byte)payload.length;
                return (short)(offset + 5 + payload.length);
            }
            int n = offset + 4;
            bytes[n] = (byte)(bytes[n] - 8);
            return (short)(offset + 5 + (bytes[offset + 4] & 0xFF));
        }
        catch (GeneralSecurityException e) {
            log.error("Decryption failed", (Throwable)e);
            this.resetSecurity();
            ISOException.throwIt((short)27013);
            return 0;
        }
    }

    @Override
    public short decryptData(byte[] buffer, short offset, short length) throws ISOException {
        Objects.requireNonNull(buffer);
        if (length % 8 != 0) {
            ISOException.throwIt((short)26368);
        }
        if ((this.state & 0xFFFFFF80) == 0) {
            ISOException.throwIt((short)27013);
        }
        try {
            byte[] result = SCP02SecureChannelImpl.des3_ecb_decrypt(Arrays.copyOfRange(buffer, (int)offset, offset + length), this.dekKey);
            log.debug("Decrypted: {}", (Object)Hex.toHexString((byte[])result));
            Util.arrayCopyNonAtomic(result, (short)0, buffer, offset, (short)result.length);
            return (short)result.length;
        }
        catch (GeneralSecurityException e) {
            log.error("Could not decrypt data: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException((Throwable)e);
        }
    }

    @Override
    public short encryptData(byte[] bytes, short i, short i1) throws ISOException {
        throw new UnsupportedOperationException("SecureChannel.encryptData()");
    }

    @Override
    public void resetSecurity() {
        this.state = 0;
        this.open = false;
        Arrays.fill(this.icv, (byte)0);
        Arrays.fill(this.host_challenge, (byte)0);
        Arrays.fill(this.card_challenge, (byte)0);
        if (this.encKey != null) {
            Arrays.fill(this.encKey, (byte)0);
        }
        if (this.macKey != null) {
            Arrays.fill(this.macKey, (byte)0);
        }
        if (this.dekKey != null) {
            Arrays.fill(this.dekKey, (byte)0);
        }
    }

    @Override
    public byte getSecurityLevel() {
        return this.state;
    }
}

