/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.base;

import com.licel.jcardsim.base.APDUHelper;
import com.licel.jcardsim.base.Simulator;
import com.licel.jcardsim.utils.ByteUtil;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import javacard.framework.APDU;
import javacard.framework.APDUException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentAPDU {
    private static final Logger log = LoggerFactory.getLogger(CurrentAPDU.class);
    private static final short APDU_BUFFER_SIZE = 261;
    public static final short T0_IBS = 1;
    public static final short T0_OBS = 258;
    public static final short T1_BLOCK_SIZE = 254;
    private static final byte T0_NAD = 0;
    private short[] ramVars;
    private static final byte LE = 0;
    private static final byte LR = 1;
    private static final byte LC = 2;
    private static final byte RAM_VARS_LENGTH = 3;
    private int current_pos = 0;
    private short remaining_bytes = 0;
    private byte protocol = 0;
    private byte state = 0;
    private final byte[] apdu_buffer = new byte[261];
    private byte[] incoming_buffer;
    private boolean extended;
    private boolean available = false;
    private final APDU apdu;

    CurrentAPDU() {
        this.ramVars = new short[3];
        try {
            Constructor ctor = APDU.class.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            this.apdu = (APDU)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new Error("Could not set up simulator");
        }
    }

    public byte[] getBuffer() {
        return this.apdu_buffer;
    }

    public short getInBlockSize() {
        return (this.getProtocol() & 1) == 1 ? (short)254 : 1;
    }

    public short getOutBlockSize() {
        return (this.getProtocol() & 1) == 1 ? (short)254 : 258;
    }

    public byte getProtocol() {
        return this.protocol;
    }

    public byte getNAD() {
        return 0;
    }

    public short setOutgoing() throws APDUException {
        if (this.state > 3) {
            APDUException.throwIt((short)1);
        }
        this.state = (byte)3;
        return this.ramVars[0];
    }

    public short setOutgoingNoChaining() throws APDUException {
        if (this.state >= 3) {
            APDUException.throwIt((short)1);
        }
        this.state = (byte)3;
        return this.ramVars[0];
    }

    public void setOutgoingLength(short len) throws APDUException {
        short max;
        short s = max = this.extended ? (short)Short.MAX_VALUE : 258;
        if (this.state >= 4) {
            APDUException.throwIt((short)1);
        }
        if (len > max || len < 0) {
            APDUException.throwIt((short)3);
        }
        this.state = (byte)4;
        this.ramVars[1] = len;
    }

    public short receiveBytes(short bOff) throws APDUException {
        if (this.state == 2) {
            return 0;
        }
        if (this.state > 2) {
            APDUException.throwIt((short)1);
        }
        if (bOff < 0 || this.remaining_bytes >= 1 && bOff + 1 > this.apdu_buffer.length) {
            APDUException.throwIt((short)2);
        }
        if (this.remaining_bytes != 0) {
            short chunklen = (short)(this.apdu_buffer.length - bOff);
            if (this.remaining_bytes < chunklen) {
                chunklen = this.remaining_bytes;
            }
            this.remaining_bytes = (short)(this.remaining_bytes - chunklen);
            System.arraycopy(this.incoming_buffer, this.current_pos, this.apdu_buffer, bOff, chunklen);
            this.current_pos += chunklen;
            this.state = this.remaining_bytes == 0 ? (byte)2 : (byte)1;
            return chunklen;
        }
        this.state = (byte)2;
        return 0;
    }

    public short setIncomingAndReceive() throws APDUException {
        if (this.state != 0) {
            APDUException.throwIt((short)1);
        }
        return this.receiveBytes(this.extended ? (short)7 : 5);
    }

    public void sendBytes(short bOff, short len) throws APDUException {
        int max;
        int n = max = this.extended ? Short.MAX_VALUE : 258;
        if (bOff < 0 || len < 0 || (short)(bOff + len) > this.apdu_buffer.length) {
            APDUException.throwIt((short)2);
        }
        if (this.state < 4) {
            APDUException.throwIt((short)1);
        }
        if (len == 0) {
            return;
        }
        short Lr = this.ramVars[1];
        if (len > Lr) {
            APDUException.throwIt((short)1);
        }
        Simulator.current().sendAPDU(this.apdu_buffer, bOff, len);
        Lr = (short)(Lr - len);
        this.state = Lr == 0 ? (byte)6 : (byte)5;
        this.ramVars[1] = Lr;
    }

    public void sendBytesLong(byte[] outData, short bOff, short len) throws APDUException, SecurityException {
        int sendLength = this.apdu_buffer.length;
        while (len > 0) {
            if (len < sendLength) {
                sendLength = len;
            }
            System.arraycopy(outData, bOff, this.apdu_buffer, 0, sendLength);
            this.sendBytes((short)0, (short)sendLength);
            len = (short)(len - sendLength);
            bOff = (short)(bOff + sendLength);
        }
    }

    public void setOutgoingAndSend(short bOff, short len) throws APDUException {
        this.setOutgoing();
        this.setOutgoingLength(len);
        this.sendBytes(bOff, len);
    }

    public byte getCurrentState() {
        return this.state;
    }

    public APDU getCurrentAPDU() throws SecurityException {
        if (!this.available) {
            throw new SecurityException("getCurrentAPDU must not be called outside of Applet#process()");
        }
        return this.apdu;
    }

    public byte getCLAChannel() {
        return 0;
    }

    public void waitExtension() throws APDUException {
    }

    public boolean isCommandChainingCLA() {
        return (this.apdu_buffer[0] & 0x10) == 16;
    }

    public boolean isValidCLA() {
        return this.apdu_buffer[0] != -1 && (this.apdu_buffer[0] & 0xE0) != 32;
    }

    public boolean isSecureMessagingCLA() {
        return (this.apdu_buffer[0] & 0x40) == 64 ? (this.apdu_buffer[0] & 0x20) == 32 : (this.apdu_buffer[0] & 0xC) != 0;
    }

    public boolean isISOInterindustryCLA() {
        return (this.apdu_buffer[0] & 0x80) != 128;
    }

    public short getIncomingLength() {
        if (this.state != 1 && this.state != 2) {
            throw new APDUException(1);
        }
        return this.ramVars[2];
    }

    public short getOffsetCdata() {
        if (this.state <= 0 || this.state > 2) {
            APDUException.throwIt((short)1);
        }
        return this.extended ? (short)7 : 5;
    }

    void disable() {
        this.available = false;
    }

    void reset(byte protocol, byte[] inputBuffer) {
        short lc;
        Arrays.fill(this.apdu_buffer, (byte)0);
        Arrays.fill(this.ramVars, (short)0);
        this.incoming_buffer = (byte[])inputBuffer.clone();
        this.state = 0;
        this.protocol = protocol;
        this.available = true;
        int apduCase = APDUHelper.getAPDUCase(inputBuffer);
        this.extended = APDUHelper.isExtendedAPDU(apduCase);
        System.arraycopy(this.incoming_buffer, 0, this.apdu_buffer, 0, apduCase == 1 ? 4 : (this.extended ? 7 : 5));
        this.current_pos = (short)(this.extended ? 7 : 5);
        int le = switch (apduCase) {
            case 2 -> {
                lc = 0;
                byte leByte = this.incoming_buffer[4];
                yield (short)(leByte == 0 ? 256 : (short)(0xFF & leByte));
            }
            case 3 -> {
                lc = 0;
                yield ByteUtil.getShort(this.incoming_buffer, 5);
            }
            case 4 -> {
                lc = (short)(0xFF & this.incoming_buffer[4]);
                yield 0;
            }
            case 5 -> {
                lc = ByteUtil.getShort(this.incoming_buffer, 5);
                yield 0;
            }
            case 6 -> {
                lc = (short)(0xFF & this.incoming_buffer[4]);
                byte leByte = this.incoming_buffer[5 + lc];
                yield (short)(leByte == 0 ? 256 : (short)(0xFF & leByte));
            }
            case 7 -> {
                lc = ByteUtil.getShort(this.incoming_buffer, 5);
                yield ByteUtil.getShort(this.incoming_buffer, 7 + lc);
            }
            default -> {
                lc = 0;
                yield 0;
            }
        };
        this.ramVars[2] = this.remaining_bytes = lc;
        this.ramVars[0] = le;
    }

    public APDU getAPDU() {
        return this.apdu;
    }
}

