/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.engine.globalplatform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javacard.framework.AID;
import javacard.framework.Applet;
import org.globalplatform.CVM;
import org.globalplatform.SecureChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.engine.JavaCardEngineException;
import pro.javacard.engine.globalplatform.GlobalPINImpl;
import pro.javacard.engine.globalplatform.SCP02SecureChannelImpl;
import pro.javacard.engine.globalplatform.SCP03SecureChannelImpl;

public class GlobalPlatform {
    private static final Logger log = LoggerFactory.getLogger(GlobalPlatform.class);
    private final SecureChannel sc = System.getProperty("pro.javacard.engine.scp02", "false").equals("true") ? new SCP02SecureChannelImpl() : new SCP03SecureChannelImpl();
    private final GlobalPINImpl gpin = new GlobalPINImpl();
    private byte card_state = (byte)15;
    private Map<GPPackage, List<GPApplet>> packages = new HashMap<GPPackage, List<GPApplet>>();

    public void loadClass(AID packageAid, AID appletAid, Class<? extends Applet> appletClass) {
        String pkgname = appletClass.getPackageName();
        GPPackage pkg = null;
        for (GPPackage p : this.packages.keySet()) {
            if (!p.pkg().equals(pkgname) && !p.aid().equals(packageAid)) continue;
            log.debug("Matching entry: {}", (Object)p);
            pkg = p;
            break;
        }
        if (pkg == null) {
            pkg = new GPPackage(pkgname, packageAid);
            this.packages.put(pkg, new ArrayList());
        }
        List<GPApplet> applets = this.packages.get(pkg);
        for (GPApplet a : applets) {
            if (!a.aid().equals(appletAid)) continue;
            log.error("Applet already present");
            throw new JavaCardEngineException("Applet already loaded");
        }
        applets.add(new GPApplet(appletAid, appletClass));
        log.info("Loaded applet {}", (Object)appletClass.getCanonicalName());
    }

    public Class<? extends Applet> locateApplet(AID packageAid, AID appletAid) {
        for (Map.Entry<GPPackage, List<GPApplet>> e : this.packages.entrySet()) {
            if (!e.getKey().aid().equals(packageAid)) continue;
            log.debug("Matched package {} by {}", (Object)e.getKey().pkg(), (Object)e.getKey().aid());
            for (GPApplet app : e.getValue()) {
                if (!app.aid().equals(appletAid)) continue;
                log.debug("Found applet {} in pkg {}", (Object)appletAid, (Object)e.getKey().pkg());
                return app.appletClass();
            }
        }
        log.warn("pkg {} / applet {} not found in registry.", (Object)packageAid, (Object)appletAid);
        return null;
    }

    public SecureChannel getSecureChannel() {
        return this.sc;
    }

    public void reset() {
        this.sc.resetSecurity();
    }

    public CVM getGlobalPIN() {
        return this.gpin;
    }

    public byte getCardState() {
        return this.card_state;
    }

    public boolean lockCard() {
        this.card_state = (byte)127;
        return false;
    }

    public boolean terminateCard() {
        this.card_state = (byte)-1;
        return false;
    }

    record GPPackage(String pkg, AID aid) {
    }

    record GPApplet(AID aid, Class<? extends Applet> appletClass) {
    }
}

