/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.base;

import com.licel.jcardsim.utils.AIDUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javacard.framework.AID;
import javacard.framework.CardException;
import javacard.framework.CardRuntimeException;
import javacard.framework.Shareable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Firewall {
    private static final Logger log = LoggerFactory.getLogger(Firewall.class);
    private final Shareable shareable;
    private final Shareable firewalled;
    private final Supplier<AID> getter;
    private final Consumer<AID> setter;
    private final Deque<AID> stack;
    private final AID serverAID;

    public Firewall(AID server, Supplier<AID> current, Consumer<AID> currentSetter, Deque<AID> stack, Shareable shareable) {
        Objects.requireNonNull(shareable);
        Class klass = shareable.getClass();
        Class<?>[] interfaces = Firewall.allShareables(klass);
        this.shareable = shareable;
        this.getter = current;
        this.setter = currentSetter;
        this.stack = stack;
        this.serverAID = server;
        this.firewalled = (Shareable)Proxy.newProxyInstance(klass.getClassLoader(), interfaces, this::invoke);
    }

    static Class<?>[] allShareables(Class<?> klass) {
        HashSet interfaces = new HashSet();
        Class<?> current = klass;
        while (!current.equals(Object.class)) {
            for (Class<?> iface : current.getInterfaces()) {
                if (!Shareable.class.isAssignableFrom(iface)) continue;
                log.debug("Adding {}", (Object)iface.getName());
                Collections.addAll(interfaces, current.getInterfaces());
            }
            current = current.getSuperclass();
        }
        return (Class[])interfaces.toArray(Class[]::new);
    }

    Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        AID current = this.getter.get();
        log.info("Switching from {} to {}", (Object)AIDUtil.toString(current), (Object)AIDUtil.toString(this.serverAID));
        this.stack.push(current);
        try {
            this.setter.accept(this.serverAID);
            Object object = method.invoke((Object)this.shareable, args);
            return object;
        }
        catch (InvocationTargetException e) {
            Throwable real = e.getTargetException();
            if (real instanceof CardException) {
                CardException ce = (CardException)real;
                log.info("{} from shareable: {}", (Object)real.getClass().getSimpleName(), (Object)ce.getReason());
            } else if (real instanceof CardRuntimeException) {
                CardRuntimeException cre = (CardRuntimeException)real;
                log.info("{} from shareable: {}", (Object)real.getClass().getSimpleName(), (Object)cre.getReason());
            } else {
                log.info("{} from shareable", (Object)real.getClass().getSimpleName());
            }
            throw real;
        }
        finally {
            this.setter.accept(this.stack.pop());
        }
    }

    public Shareable getShareable() {
        return this.firewalled;
    }
}

