/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.ECKeyImpl;
import javacard.security.CryptoException;
import javacard.security.ECPrivateKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;

public class ECPrivateKeyImpl
extends ECKeyImpl
implements ECPrivateKey {
    protected ByteContainer s;

    public ECPrivateKeyImpl(byte keyType, short keySize, byte memoryType) {
        super(keyType, keySize, memoryType);
        this.s = new ByteContainer(memoryType);
    }

    public ECPrivateKeyImpl(ECPrivateKeyParameters params) {
        super((ECKeyParameters)params);
        this.setParameters((CipherParameters)params);
    }

    @Override
    public void setParameters(CipherParameters params) {
        this.s.setBigInteger(((ECPrivateKeyParameters)params).getD());
    }

    @Override
    public void setS(byte[] buffer, short offset, short length) throws CryptoException {
        this.s.setBytes(buffer, offset, length);
    }

    @Override
    public short getS(byte[] buffer, short offset) throws CryptoException {
        return this.s.getBytes(buffer, offset);
    }

    @Override
    public boolean isInitialized() {
        return this.isDomainParametersInitialized() && this.s.isInitialized();
    }

    @Override
    public void clearKey() {
        super.clearKey();
        this.s.clear();
    }

    @Override
    public CipherParameters getParameters() {
        if (!this.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        return new ECPrivateKeyParameters(this.s.getBigInteger(), this.getDomainParameters());
    }
}

