/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.KeyImpl;
import java.math.BigInteger;
import java.security.SecureRandom;
import javacard.security.CryptoException;
import javacard.security.DHKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.util.encoders.Hex;

public abstract class DHKeyImpl
extends KeyImpl
implements DHKey {
    public static final short LENGTH_DH_1536 = 1536;
    protected ByteContainer p = new ByteContainer();
    protected ByteContainer q = new ByteContainer();
    protected ByteContainer g = new ByteContainer();
    private static final String rfc2409_1024_p = "FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381FFFFFFFFFFFFFFFF";
    private static final String rfc2409_1024_g = "02";
    public static final DHParameters rfc2409_1024 = DHKeyImpl.fromPG("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381FFFFFFFFFFFFFFFF", "02");
    private static final String rfc3526_1536_p = "FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA237327FFFFFFFFFFFFFFFF";
    private static final String rfc3526_1536_g = "02";
    public static final DHParameters rfc3526_1536 = DHKeyImpl.fromPG("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA237327FFFFFFFFFFFFFFFF", "02");
    private static final String rfc3526_2048_p = "FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AACAA68FFFFFFFFFFFFFFFF";
    private static final String rfc3526_2048_g = "02";
    public static final DHParameters rfc3526_2048 = DHKeyImpl.fromPG("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AACAA68FFFFFFFFFFFFFFFF", "02");

    @Override
    public void setParameters(CipherParameters params) {
        DHParameters dhParam = (DHParameters)params;
        this.g.setBigInteger(dhParam.getG());
        this.p.setBigInteger(dhParam.getP());
        if (dhParam.getQ() != null) {
            this.q.setBigInteger(dhParam.getQ());
        }
    }

    @Override
    public CipherParameters getParameters() {
        if (!this.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        if (this.q.isInitialized()) {
            return new DHParameters(this.p.getBigInteger(), this.g.getBigInteger(), this.q.getBigInteger());
        }
        return new DHParameters(this.p.getBigInteger(), this.g.getBigInteger());
    }

    @Override
    public void setP(byte[] bytes, short offset, short length) throws CryptoException {
        this.p.setBytes(bytes, offset, length);
    }

    @Override
    public void setQ(byte[] bytes, short offset, short length) throws CryptoException {
        this.q.setBytes(bytes, offset, length);
    }

    @Override
    public void setG(byte[] bytes, short offset, short length) throws CryptoException {
        this.g.setBytes(bytes, offset, length);
    }

    @Override
    public short getP(byte[] bytes, short offset) {
        return this.p.getBytes(bytes, offset);
    }

    @Override
    public short getQ(byte[] bytes, short offset) {
        return this.q.getBytes(bytes, offset);
    }

    @Override
    public short getG(byte[] bytes, short offset) {
        return this.g.getBytes(bytes, offset);
    }

    @Override
    public void clearKey() {
        this.p.clear();
        this.q.clear();
        this.g.clear();
    }

    @Override
    public boolean isInitialized() {
        return this.p.isInitialized() && this.g.isInitialized();
    }

    @Override
    public KeyGenerationParameters getKeyGenerationParameters(SecureRandom rnd) {
        if (this.p.isInitialized() && this.g.isInitialized()) {
            if (this.q.isInitialized()) {
                return new DHKeyGenerationParameters(rnd, new DHParameters(this.p.getBigInteger(), this.g.getBigInteger(), this.q.getBigInteger()));
            }
            return new DHKeyGenerationParameters(rnd, new DHParameters(this.p.getBigInteger(), this.g.getBigInteger()));
        }
        return DHKeyImpl.getDefaultKeyGenerationParameters(this.size, rnd);
    }

    static KeyGenerationParameters getDefaultKeyGenerationParameters(short keySize, SecureRandom rnd) {
        switch (keySize) {
            case 1024: {
                return new DHKeyGenerationParameters(rnd, rfc2409_1024);
            }
            case 1536: {
                return new DHKeyGenerationParameters(rnd, rfc3526_1536);
            }
            case 2048: {
                return new DHKeyGenerationParameters(rnd, rfc3526_2048);
            }
        }
        CryptoException.throwIt((short)1);
        return null;
    }

    private static DHParameters fromPG(String hexP, String hexG) {
        BigInteger p = new BigInteger(1, Hex.decode((String)hexP));
        BigInteger g = new BigInteger(1, Hex.decode((String)hexG));
        return new DHParameters(p, g);
    }
}

