/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.DSAKeyImpl;
import javacard.security.CryptoException;
import javacard.security.DSAPublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.DSAKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;

public class DSAPublicKeyImpl
extends DSAKeyImpl
implements DSAPublicKey {
    protected ByteContainer y = new ByteContainer();

    public DSAPublicKeyImpl(short keySize) {
        super((byte)7, keySize);
    }

    @Override
    public void setParameters(CipherParameters params) {
        super.setParameters(params);
        this.y.setBigInteger(((DSAPublicKeyParameters)params).getY());
    }

    @Override
    public void setY(byte[] buffer, short offset, short length) throws CryptoException {
        this.y.setBytes(buffer, offset, length);
    }

    @Override
    public short getY(byte[] buffer, short offset) {
        return this.y.getBytes(buffer, offset);
    }

    @Override
    public boolean isInitialized() {
        return super.isInitialized() && this.y.isInitialized();
    }

    @Override
    public void clearKey() {
        super.clearKey();
        this.y.clear();
    }

    @Override
    public CipherParameters getParameters() {
        if (!this.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        return new DSAPublicKeyParameters(this.y.getBigInteger(), ((DSAKeyParameters)super.getParameters()).getParameters());
    }
}

