/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.KeyImpl;
import java.security.SecureRandom;
import javacard.security.AESKey;
import javacard.security.CryptoException;
import javacard.security.DESKey;
import javacard.security.HMACKey;
import javacard.security.KoreanSEEDKey;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.MultiBlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.SEEDEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmetricKeyImpl
extends KeyImpl
implements DESKey,
AESKey,
HMACKey,
KoreanSEEDKey {
    private static final Logger log = LoggerFactory.getLogger(SymmetricKeyImpl.class);
    protected ByteContainer key;

    public SymmetricKeyImpl(byte keyType, short keySize) {
        this.size = keySize;
        this.type = keyType;
        switch (keyType) {
            case 2: 
            case 14: 
            case 17: 
            case 20: {
                this.key = new ByteContainer(2);
                break;
            }
            case 1: 
            case 13: 
            case 16: 
            case 19: {
                this.key = new ByteContainer(1);
                break;
            }
            case 3: 
            case 15: 
            case 18: 
            case 21: {
                this.key = new ByteContainer(0);
                break;
            }
        }
    }

    @Override
    public void clearKey() {
        this.key.clear();
    }

    @Override
    public void setKey(byte[] keyData, short kOff) throws CryptoException, NullPointerException, ArrayIndexOutOfBoundsException {
        this.key.setBytes(keyData, kOff, (short)(this.size / 8));
    }

    @Override
    public void setKey(byte[] keyData, short kOff, short kLen) throws CryptoException, NullPointerException, ArrayIndexOutOfBoundsException {
        this.key.setBytes(keyData, kOff, kLen);
    }

    @Override
    public byte getKey(byte[] keyData, short kOff) {
        return (byte)this.key.getBytes(keyData, kOff);
    }

    @Override
    public void setParameters(CipherParameters params) {
        this.key.setBytes(((KeyParameter)params).getKey());
    }

    @Override
    public CipherParameters getParameters() throws CryptoException {
        if (!this.key.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        return new KeyParameter(this.key.getBytes((byte)1));
    }

    BlockCipher getCipher() throws CryptoException {
        if (!this.key.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        MultiBlockCipher cipher = null;
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: {
                if (this.size == 64) {
                    cipher = new DESEngine();
                }
                if (this.size != 128 && this.size != 192) break;
                cipher = new DESedeEngine();
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                cipher = AESEngine.newInstance();
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                cipher = new SEEDEngine();
                break;
            }
            case 21: {
                break;
            }
            default: {
                log.warn("Unhandled key type: " + this.type);
            }
        }
        return cipher;
    }

    @Override
    public boolean isInitialized() {
        return this.key.isInitialized();
    }

    @Override
    public KeyGenerationParameters getKeyGenerationParameters(SecureRandom rnd) {
        return null;
    }
}

