/*
 * Copyright 2025 Martin Paljak
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.licel.jcardsim.base;

import org.bouncycastle.util.encoders.Hex;

public class Helpers {
    // Utility method to create realistic installation parameters with instance AID, privileges and application parameters
    public static byte[] install_parameters(byte[] aid, byte[] privileges, byte[] params) {
        if (params == null)
            params = new byte[0];
        if (privileges == null)
            privileges = new byte[1];

        byte[] data = new byte[1 + aid.length + 1 + privileges.length + 1 + params.length];
        int offset = 0;

        data[offset++] = (byte) aid.length;
        System.arraycopy(aid, 0, data, offset, aid.length);
        offset += aid.length;

        data[offset++] = (byte) privileges.length;
        System.arraycopy(privileges, 0, data, offset, privileges.length);
        offset += privileges.length;

        data[offset++] = (byte) params.length;
        System.arraycopy(params, 0, data, offset, params.length);
        return data;
    }
}
